/*
 * Decompiled with CFR 0.152.
 */
package org.openhab.binding.philipsair.internal.connection;

import com.google.gson.Gson;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import java.io.UnsupportedEncodingException;
import java.security.GeneralSecurityException;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import javax.crypto.BadPaddingException;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.jetty.client.HttpClient;
import org.eclipse.jetty.client.api.ContentProvider;
import org.eclipse.jetty.client.api.ContentResponse;
import org.eclipse.jetty.client.api.Request;
import org.eclipse.jetty.client.util.StringContentProvider;
import org.eclipse.jetty.http.HttpMethod;
import org.openhab.binding.philipsair.internal.PhilipsAirConfiguration;
import org.openhab.binding.philipsair.internal.connection.PhilipsAirAPIConnection;
import org.openhab.binding.philipsair.internal.connection.PhilipsAirAPIException;
import org.openhab.binding.philipsair.internal.connection.PhilipsAirCipher;
import org.openhab.binding.philipsair.internal.model.PhilipsAirPurifierDataDTO;
import org.openhab.binding.philipsair.internal.model.PhilipsAirPurifierDeviceDTO;
import org.openhab.binding.philipsair.internal.model.PhilipsAirPurifierFiltersDTO;
import org.openhab.binding.philipsair.internal.model.PhilipsAirPurifierWritableDataDTO;
import org.openhab.core.cache.ExpiringCacheMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@NonNullByDefault
public class PhilipsAirHttpAPIConnection
extends PhilipsAirAPIConnection {
    private final Logger logger = LoggerFactory.getLogger(PhilipsAirHttpAPIConnection.class);
    private static final String BASE_UPNP_URL = "http://%HOST%/upnp/description.xml";
    private static final String STATUS_URL = "http://%HOST%/di/v1/products/1/air";
    private static final String DEVICE_URL = "http://%HOST%/di/v1/products/1/device";
    private static final String USERINFO_URL = "http://%HOST%/di/v1/products/0/userinfo";
    private static final String KEY_URL = "http://%HOST%/di/v1/products/0/security";
    private static final String FILTERS_URL = "http://%HOST%/di/v1/products/1/fltsts";
    private static final String FIRMWARE_URL = "http://%HOST%/di/v1/products/0/firmware";
    private final ExpiringCacheMap<String, String> cache;
    private final Gson gson = new Gson();
    private long cooldownTimer = 0L;
    private @Nullable PhilipsAirCipher cipher = null;
    private HttpClient httpClient;

    public PhilipsAirHttpAPIConnection(PhilipsAirConfiguration config, HttpClient httpClient) {
        super(config);
        this.httpClient = httpClient;
        this.cache = new ExpiringCacheMap(TimeUnit.SECONDS.toMillis(config.getRefreshInterval()));
        this.config = config;
        this.initCipher();
    }

    private void initCipher() {
        try {
            PhilipsAirCipher cipher = new PhilipsAirCipher();
            if (this.config.getKey() != null && this.config.getKey().isEmpty()) {
                this.exchangeKeys();
            }
            cipher.initKey(this.config.getKey());
            this.cipher = cipher;
        }
        catch (InterruptedException | GeneralSecurityException | PhilipsAirAPIException e) {
            this.logger.warn("An exception occured", (Throwable)e);
            this.cipher = null;
        }
    }

    public synchronized @Nullable String getAirPurifierInfo(String host) throws JsonSyntaxException, PhilipsAirAPIException {
        return this.getResponseFromCache(PhilipsAirHttpAPIConnection.buildURL(BASE_UPNP_URL, host), false);
    }

    @Override
    public synchronized @Nullable PhilipsAirPurifierDataDTO getAirPurifierStatus(String host) throws JsonSyntaxException, PhilipsAirAPIException {
        return (PhilipsAirPurifierDataDTO)this.gson.fromJson(this.getResponseFromCache(PhilipsAirHttpAPIConnection.buildURL(STATUS_URL, host), true), PhilipsAirPurifierDataDTO.class);
    }

    public synchronized @Nullable String getAirPurifierKey(String host) throws JsonSyntaxException, PhilipsAirAPIException {
        return this.getResponseFromCache(PhilipsAirHttpAPIConnection.buildURL(KEY_URL, host), true);
    }

    public synchronized @Nullable String getAirPurifierFirmware(String host) throws JsonSyntaxException, PhilipsAirAPIException {
        return this.getResponseFromCache(PhilipsAirHttpAPIConnection.buildURL(FIRMWARE_URL, host), true);
    }

    @Override
    public synchronized @Nullable PhilipsAirPurifierDeviceDTO getAirPurifierDevice(String host) throws JsonSyntaxException, PhilipsAirAPIException {
        return (PhilipsAirPurifierDeviceDTO)this.gson.fromJson(this.getResponseFromCache(PhilipsAirHttpAPIConnection.buildURL(DEVICE_URL, host), true), PhilipsAirPurifierDeviceDTO.class);
    }

    private synchronized @Nullable String getAirPurifierUserinfo(String host) throws JsonSyntaxException, PhilipsAirAPIException {
        return this.getResponseFromCache(PhilipsAirHttpAPIConnection.buildURL(USERINFO_URL, host), true);
    }

    @Override
    public synchronized @Nullable PhilipsAirPurifierFiltersDTO getAirPurifierFiltersStatus(String host) throws JsonSyntaxException, PhilipsAirAPIException {
        return (PhilipsAirPurifierFiltersDTO)this.gson.fromJson(this.getResponseFromCache(PhilipsAirHttpAPIConnection.buildURL(FILTERS_URL, host), true), PhilipsAirPurifierFiltersDTO.class);
    }

    private static String buildURL(String url, String host) {
        return url.replaceFirst("%HOST%", host);
    }

    private @Nullable String getResponseFromCache(String url, boolean decrypt) {
        return (String)this.cache.putIfAbsentAndGet((Object)url, () -> this.getResponse(url, HttpMethod.GET, null, decrypt));
    }

    private String getResponse(String url, HttpMethod method, @Nullable String content, boolean decode) throws PhilipsAirAPIException {
        try {
            if (decode && this.cipher == null) {
                this.logger.warn("Cipher not initialized");
                this.config.setKey("");
                this.initCipher();
            }
            if (this.cooldownTimer > System.currentTimeMillis()) {
                this.logger.debug("Cooldown period is active, waiting Philips Air Purifier device responded with status code");
                throw new PhilipsAirAPIException("Cooldown period is active, waiting Philips Air Purifier device responded with status code");
            }
            Request request = this.httpClient.newRequest(url).method(method);
            if (method == HttpMethod.PUT && content != null && !content.isEmpty()) {
                request.content((ContentProvider)new StringContentProvider(content));
            }
            ContentResponse contentResponse = request.timeout((long)this.config.getRefreshInterval(), TimeUnit.SECONDS).send();
            int httpStatus = contentResponse.getStatus();
            String finalcontent = contentResponse.getContentAsString();
            this.logger.trace("Philips Air Purifier device encrypted response: '{}'", (Object)finalcontent);
            if (decode) {
                try {
                    finalcontent = this.cipher.decrypt(finalcontent);
                }
                catch (BadPaddingException bexp) {
                    this.config.setKey("");
                    this.initCipher();
                    finalcontent = this.cipher.decrypt(finalcontent);
                }
            }
            this.logger.debug("Philips Air Purifier device response: status = {}, content = '{}'", (Object)httpStatus, (Object)finalcontent);
            switch (httpStatus) {
                case 200: {
                    if (finalcontent != null) {
                        return finalcontent;
                    }
                }
                case 400: 
                case 401: 
                case 404: {
                    this.logger.debug("Philips Air Purifier device responded with status code {}", (Object)httpStatus);
                    throw new PhilipsAirAPIException(String.format("Error with status %d", httpStatus));
                }
                case 429: {
                    this.cooldownTimer = System.currentTimeMillis() + TimeUnit.MINUTES.toMillis(5L);
                }
            }
            this.logger.debug("Philips Air Purifier device responded with status code {}", (Object)httpStatus);
            throw new PhilipsAirAPIException(String.format("Error with status %d", httpStatus));
        }
        catch (ExecutionException e) {
            String errorMessage = e.getLocalizedMessage() != null ? e.getLocalizedMessage() : e.getMessage();
            this.logger.trace("Exception occurred during execution: {}", (Object)errorMessage, (Object)e);
            throw new PhilipsAirAPIException(errorMessage, e);
        }
        catch (InterruptedException | TimeoutException e) {
            String errorMessage = e.getLocalizedMessage() != null ? e.getLocalizedMessage() : e.getMessage();
            this.logger.debug("Exception occurred during execution: {}", (Object)errorMessage, (Object)e);
            throw new PhilipsAirAPIException(errorMessage, e);
        }
        catch (Exception e) {
            String errorMessage = e.getLocalizedMessage() != null ? e.getLocalizedMessage() : e.getMessage();
            this.logger.warn("Unexpected exception occurred during execution: {}", (Object)errorMessage, (Object)e);
            throw new PhilipsAirAPIException(errorMessage, e);
        }
    }

    public @Nullable String exchangeKeys() throws PhilipsAirAPIException, InterruptedException {
        String aesKey;
        PhilipsAirCipher cipher = this.cipher;
        if (cipher == null) {
            return null;
        }
        String url = PhilipsAirHttpAPIConnection.buildURL(KEY_URL, this.config.getHost());
        String data = "{\"diffie\":\"" + cipher.getApow() + "\"}";
        String encodedContent = this.getResponse(url, HttpMethod.PUT, data, false);
        JsonObject encodedJson = (JsonObject)this.gson.fromJson(encodedContent, JsonObject.class);
        String key = encodedJson.get("key").getAsString();
        String hellman = encodedJson.get("hellman").getAsString();
        try {
            aesKey = cipher.calculateKey(hellman, key);
        }
        catch (GeneralSecurityException | ExecutionException | TimeoutException e) {
            throw new PhilipsAirAPIException(e);
        }
        this.config.setKey(aesKey);
        this.cipher = cipher;
        return aesKey;
    }

    @Override
    public @Nullable PhilipsAirPurifierDataDTO sendCommand(String parameter, PhilipsAirPurifierWritableDataDTO value) throws PhilipsAirAPIException {
        String commandValue;
        block4: {
            PhilipsAirCipher cipher = this.cipher;
            if (cipher == null) {
                return null;
            }
            commandValue = this.gson.toJson((Object)value);
            this.logger.debug("{}", (Object)commandValue);
            commandValue = cipher.encrypt(commandValue.toString());
            if (commandValue != null && !commandValue.isEmpty()) break block4;
            return null;
        }
        try {
            String response = this.getResponse(PhilipsAirHttpAPIConnection.buildURL(STATUS_URL, this.config.getHost()), HttpMethod.PUT, commandValue.toString(), true);
            this.logger.debug("{}", (Object)response);
            return (PhilipsAirPurifierDataDTO)this.gson.fromJson(response, PhilipsAirPurifierDataDTO.class);
        }
        catch (JsonSyntaxException | UnsupportedEncodingException | InvalidAlgorithmParameterException | InvalidKeyException | NoSuchAlgorithmException | BadPaddingException | IllegalBlockSizeException | NoSuchPaddingException | PhilipsAirAPIException e) {
            throw new PhilipsAirAPIException(e);
        }
    }

    @Override
    public PhilipsAirConfiguration getConfig() {
        return this.config;
    }
}

