/*
 * Decompiled with CFR 0.152.
 */
package org.openhab.binding.philipsair.internal;

import java.util.Collections;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.measure.Unit;
import javax.measure.quantity.Dimensionless;
import javax.measure.quantity.Temperature;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.openhab.core.library.dimension.Density;
import org.openhab.core.library.unit.SIUnits;
import org.openhab.core.library.unit.Units;
import org.openhab.core.thing.ThingTypeUID;

@NonNullByDefault
public class PhilipsAirBindingConstants {
    private static final String BINDING_ID = "philipsair";
    public static final String VENDOR = "Philips";
    public static final String SUPPORTED_MODEL_UNIVERSAL = "universal";
    public static final String SUPPORTED_MODEL_NUMBER_AC2889_10 = "ac2889_10";
    public static final String SUPPORTED_MODEL_NUMBER_AC2729 = "ac2729";
    public static final String SUPPORTED_MODEL_NUMBER_AC1214_10 = "ac1214_10";
    public static final String SUPPORTED_MODEL_NUMBER_AC3829_10 = "ac3829_10";
    public static final String SUPPORTED_MODEL_COAP = "coap";
    public static final ThingTypeUID THING_TYPE_UNIVERSAL = new ThingTypeUID("philipsair", "universal");
    public static final ThingTypeUID THING_TYPE_COAP = new ThingTypeUID("philipsair", "coap");
    public static final ThingTypeUID THING_TYPE_AC2889_10 = new ThingTypeUID("philipsair", "ac2889_10");
    public static final ThingTypeUID THING_TYPE_AC2729 = new ThingTypeUID("philipsair", "ac2729");
    public static final ThingTypeUID THING_TYPE_AC1214_10 = new ThingTypeUID("philipsair", "ac1214_10");
    public static final ThingTypeUID THING_TYPE_AC3829_10 = new ThingTypeUID("philipsair", "ac3829_10");
    public static final Set<ThingTypeUID> SUPPORTED_THING_TYPES_UIDS = Collections.unmodifiableSet(Stream.of(THING_TYPE_UNIVERSAL, THING_TYPE_COAP, THING_TYPE_AC2889_10, THING_TYPE_AC2729, THING_TYPE_AC1214_10, THING_TYPE_AC3829_10).collect(Collectors.toSet()));
    public static final Set<ThingTypeUID> SUPPORTED_UPNP_THING_TYPES_UIDS = Collections.unmodifiableSet(Stream.of(THING_TYPE_UNIVERSAL, THING_TYPE_AC2889_10, THING_TYPE_AC2729, THING_TYPE_AC1214_10, THING_TYPE_AC3829_10).collect(Collectors.toSet()));
    public static final Set<ThingTypeUID> SUPPORTED_COAP_THING_TYPES_UIDS = Collections.unmodifiableSet(Stream.of(THING_TYPE_COAP).collect(Collectors.toSet()));
    public static final String DISCOVERY_UPNP_MODEL = "AirPurifier";
    public static final String DISCOVERY_UDN = "udn";
    public static final Unit<Temperature> TEMPERATURE_UNIT = SIUnits.CELSIUS;
    public static final Unit<Dimensionless> HUMIDITY_UNIT = Units.PERCENT;
    public static final Unit<Density> DENSITY_UNIT = Units.MICROGRAM_PER_CUBICMETRE;
    public static final String PROPERTY_DEV_TYPE = "deviceType";
    public static final String PROPERTY_MANUFACTURER = "manufacturer";
    public static final String PROPERTY_NAME = "name";
    public static final String FILTERS = "filters";
    public static final String PM25 = "pm25";
    public static final String POWER = "pwr";
    public static final String FAN_MODE = "om";
    public static final String MODE = "mode";
    public static final String BUTTONS_LIGHT = "uil";
    public static final String LED_LIGHT_LEVEL = "aqil";
    public static final String DISPLAYED_INDEX = "ddp";
    public static final String ALLERGEN_INDEX = "iaql";
    public static final String AIR_QUALITY_NOTIFICATION_THRESHOLD = "aqit";
    public static final String CHILD_LOCK = "cl";
    public static final String AUTO_TIMEOFF = "dt";
    public static final String ERROR_CODE = "err";
    public static final String TIMER_COUNTDOWN = "dtrs";
    public static final String SOFTWARE_VERSION = "swversion";
    public static final String HUMIDITY = "rh";
    public static final String HUMIDITY_SETPOINT = "rhset";
    public static final String TEMPERATURE = "temp";
    public static final String FUNCTION = "func";
    public static final String WATER_LEVEL = "wl";
    public static final String PRE_FILTER = "fltsts0";
    public static final String WICKS_FILTER = "wicksts";
    public static final String CARBON_FILTER = "fltsts2";
    public static final String HEPA_FILTER = "fltsts1";
}

